/**  @file bta_math.c
*
*    @brief This file implements several mathematical functions for frames/channels
*
*    BLT_DISCLAIMER
*
*    @author Alex Falkensteiner
*
*    @cond svn
*
*    Information of last commit
*    $Rev::               $:  Revision of last commit
*    $Author::            $:  Author of last commit
*    $Date::              $:  Date of last commit
*
*    @endcond
*/

#include <bta.h>
#include <bta_helper.h>
#include <bta_filters.h>


#ifndef BTA_MATH_H_INCLUDED
#define BTA_MATH_H_INCLUDED


typedef struct BTA_FltMathInst {
    BTA_FltMathType mathType;
    BTA_ChannelId channelToProcess;
    BTA_ChannelId channelIdResult;
    float *dataFM1;                      ///< Float Matrix #1
    uint16_t xResFM1;                    ///< Number of columns of FM1
    uint16_t yResFM1;                    ///< Number of rows of FM1
    BTA_InfoEventInst *infoEventInst;
} BTA_FltMathInst;


BTA_Status BFLTmathInit(BTA_FltMathConfig *config, BTA_FltHandle *handle, BTA_InfoEventInst *infoEventInst);
BTA_Status BFLTmathClose(BTA_FltHandle *handle);
BTA_Status BFLTmathApply(BTA_FltHandle handle, BTA_Frame **frame);


#endif
